<?php
require_once __DIR__ . '/../../config/database.php';
require_once __DIR__ . '/../../includes/functions.php';

require_once __DIR__ . '/../../vendor/autoload.php'; // pastikan mPDF sudah ada
use Mpdf\Mpdf;

$id = intval($_GET['id'] ?? 0);
$db = get_db_connection();

$stmt = $db->prepare("SELECT p.*, c.full_name, c.address, c.phone, pk.package_name, pk.price 
                      FROM payments p
                      JOIN clients c ON c.id = p.client_id
                      JOIN packages pk ON pk.id = p.package_id
                      WHERE p.id = ? LIMIT 1");
$stmt->bind_param("i", $id);
$stmt->execute();
$invoice = $stmt->get_result()->fetch_assoc();

if (!$invoice) {
    die("Invoice tidak ditemukan.");
}

$html = "
<h2 style='text-align:center'>INVOICE</h2>
<hr>
<p><strong>No Invoice:</strong> {$invoice['invoice_number']}</p>
<p><strong>Pelanggan:</strong> {$invoice['full_name']}<br>
<strong>Alamat:</strong> {$invoice['address']}<br>
<strong>Telepon:</strong> {$invoice['phone']}</p>
<hr>
<table width='100%' border='1' cellspacing='0' cellpadding='6'>
<tr><th>Paket</th><th>Harga</th><th>Status</th></tr>
<tr>
<td>{$invoice['package_name']}</td>
<td>".format_currency($invoice['price'])."</td>
<td>{$invoice['payment_status']}</td>
</tr>
</table>
<hr>
<p><em>Dicetak pada: ".date('d-m-Y H:i')."</em></p>
";

$mpdf = new Mpdf();
$mpdf->WriteHTML($html);
$mpdf->Output("invoice.pdf", "I");
