<?php
require_once __DIR__ . '/../../includes/functions.php';
require_once __DIR__ . '/../../vendor/autoload.php';

use Mpdf\Mpdf;

$paymentId = isset($_GET['id']) ? (int) $_GET['id'] : 0;
if ($paymentId <= 0) {
    exit('ID invoice tidak valid.');
}

$db = get_db_connection();

$sql = "SELECT
            p.invoice_number,
            p.amount,
            p.payment_status,
            p.invoice_date,
            p.due_date,
            p.payment_date,
            c.full_name AS client_name,
            c.address AS client_address,
            c.phone AS client_phone,
            pkg.package_name,
            pkg.price
        FROM payments p
        JOIN clients c ON p.client_id = c.id
        LEFT JOIN packages pkg ON c.package_id = pkg.id
        WHERE p.id = ?";

$stmt = $db->prepare($sql);
$stmt->bind_param('i', $paymentId);
$stmt->execute();
$result = $stmt->get_result();
$invoice = $result->fetch_assoc();

if (!$invoice) {
    exit('Data invoice tidak ditemukan.');
}

$packageName = $invoice['package_name'] ?: '-';
$packagePrice = $invoice['price'] !== null ? number_format((float) $invoice['price'], 0, ',', '.') : '-';
$totalAmount = number_format((float) $invoice['amount'], 0, ',', '.');

$clientName = htmlspecialchars($invoice['client_name']);
$clientAddress = htmlspecialchars($invoice['client_address']);
$clientPhone = htmlspecialchars($invoice['client_phone']);
$invoiceNumber = htmlspecialchars($invoice['invoice_number']);
$invoiceDate = htmlspecialchars($invoice['invoice_date']);
$dueDate = htmlspecialchars($invoice['due_date']);
$paymentStatus = htmlspecialchars($invoice['payment_status']);
$packageNameSafe = htmlspecialchars($packageName);

$html = "
<h2 style='text-align:center;'>INVOICE</h2>
<hr>
<table width='100%' style='margin-bottom:20px;'>
    <tr>
        <td>
            <strong>Nama Pelanggan:</strong> {$clientName}<br>
            <strong>Alamat:</strong> {$clientAddress}<br>
            <strong>Telepon:</strong> {$clientPhone}
        </td>
        <td align='right'>
            <strong>No Invoice:</strong> {$invoiceNumber}<br>
            <strong>Tanggal Invoice:</strong> {$invoiceDate}<br>
            <strong>Jatuh Tempo:</strong> {$dueDate}
        </td>
    </tr>
</table>

<table border='1' cellpadding='8' cellspacing='0' width='100%'>
    <thead>
        <tr style='background:#f3f4f6;'>
            <th>Paket Internet</th>
            <th>Harga Paket</th>
            <th>Status Pembayaran</th>
        </tr>
    </thead>
    <tbody>
        <tr>
            <td>{$packageNameSafe}</td>
            <td>Rp {$packagePrice}</td>
            <td>{$paymentStatus}</td>
        </tr>
    </tbody>
</table>

<h3 style='text-align:right;margin-top:20px;'>
    Total: Rp {$totalAmount}
</h3>

<p style='margin-top:30px;font-size:12px;text-align:center;'>
    Terima kasih telah menggunakan layanan kami.<br>
    Invoice ini dicetak otomatis oleh sistem WISHNET - Billing System.
</p>
";

$mpdf = new Mpdf();
$mpdf->WriteHTML($html);
$mpdf->Output('Invoice-' . $invoiceNumber . '.pdf', 'I');

