<?php
require_once __DIR__ . '/../../includes/export_helpers.php';

require_login();
$db = get_db_connection();

$sql = 'SELECT p.invoice_number, c.full_name, p.amount, p.payment_status, p.invoice_date, p.due_date, p.payment_date FROM payments p JOIN clients c ON c.id = p.client_id ORDER BY p.invoice_date DESC';
$result = $db->query($sql);

$rows = [];
if ($result) {
    while ($row = $result->fetch_assoc()) {
        $rows[] = [
            $row['invoice_number'],
            $row['full_name'],
            $row['amount'],
            ucfirst($row['payment_status']),
            $row['invoice_date'],
            $row['due_date'],
            $row['payment_date'],
        ];
    }
}

export_to_excel(
    'payments',
    ['Invoice', 'Pelanggan', 'Nominal', 'Status', 'Invoice Date', 'Due Date', 'Payment Date'],
    $rows
);
