<?php
require_once __DIR__ . '/../../includes/export_helpers.php';

require_login();
$db = get_db_connection();

$result = $db->query('SELECT package_name, price, status, description FROM packages ORDER BY package_name');
$rows = [];
if ($result) {
    while ($row = $result->fetch_assoc()) {
        $rows[] = [
            $row['package_name'],
            $row['price'],
            ucfirst($row['status']),
            $row['description'],
        ];
    }
}

export_to_excel(
    'packages',
    ['Nama Paket', 'Harga', 'Status', 'Deskripsi'],
    $rows
);
