<?php
require_once __DIR__ . '/../../includes/functions.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    redirect_with_message('index.php', 'Metode tidak diizinkan.', 'danger');
}

$id = isset($_POST['id']) ? (int) $_POST['id'] : 0;
$token = $_POST['csrf_token'] ?? '';

if ($id <= 0 || !validate_csrf_token($token)) {
    redirect_with_message('index.php', 'Permintaan tidak valid.', 'danger');
}

$db = get_db_connection();
$stmt = $db->prepare('DELETE FROM packages WHERE id = ?');
if ($stmt) {
    $stmt->bind_param('i', $id);
    if ($stmt->execute()) {
        redirect_with_message('index.php', 'Paket berhasil dihapus.', 'success');
    }
}

redirect_with_message('index.php', 'Gagal menghapus paket.', 'danger');