<?php
require_once __DIR__ . '/functions.php';
require_login();

$user = current_user();
$pageTitle = $pageTitle ?? APP_NAME;
$activeMenu = $activeMenu ?? '';
$breadcrumbs = $breadcrumbs ?? [];

if (empty($breadcrumbs)) {
    $breadcrumbs[] = [
        'label' => 'Dashboard',
        'url' => base_url('dashboard.php'),
    ];

    if ($activeMenu !== 'dashboard') {
        $breadcrumbs[] = [
            'label' => $pageTitle,
            'url' => null,
        ];
    }
}

$breadcrumbLastIndex = count($breadcrumbs) - 1;
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title><?php echo htmlspecialchars($pageTitle); ?></title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Ubuntu:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.datatables.net/v/bs5/dt-1.13.6/datatables.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" integrity="sha512-8rP77K0O5gYv7FpC18JNpDutVdGs14Q6gttz43ZR7gp6ww1zM0RKZ77N8BINU3CFAaj6MqFmoVoe2r2ZzJenTw==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="stylesheet" href="<?php echo base_url('assets/css/styles.css?v=' . time()); ?>">
    <style>
        /* Memberikan latar hijau pudar pada header tabel */
        .table > thead {
            background-color: #d1e7dd; /* Bootstrap's success-subtle color */
            --bs-table-bg: #d1e7dd; /* Override Bootstrap variable for striped tables */
            --bs-table-accent-bg: #d1e7dd; /* Override Bootstrap variable for hover */
        }

        /* Mengubah warna breadcrumb aktif menjadi abu-abu muda */
        .breadcrumb-item.active {
            color: #6c757d; /* Bootstrap's text-muted color */
        }

        /* Mengubah warna separator (/) pada breadcrumb */
        .breadcrumb-item + .breadcrumb-item::before {
            color: #6c757d;
        }
    </style>
</head>
<body>
<header class="topbar">
    <nav class="navbar navbar-expand-lg navbar-main">
        <div class="container-fluid px-0">
            <a class="brand-link" href="<?php echo base_url('dashboard.php'); ?>">
                <span class="brand-logo">WN</span>
                <span class="brand-text">
                    <span class="brand-title">WISHNET</span>
                    <span class="brand-subtitle">Billing System</span>
                    </span>
            </a>
            <div class="d-flex align-items-center gap-2 ms-auto order-lg-2">
                <div class="user-chip d-none d-lg-inline-flex">
                    <i class="fa-solid fa-user-astronaut"></i>
                    <span><?php echo htmlspecialchars($user['full_name']); ?></span>
                    <span class="role-pill"><?php echo htmlspecialchars($user['role']); ?></span>
                </div>
                <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#mainNav" aria-controls="mainNav" aria-expanded="false" aria-label="Toggle navigation">
                    <span class="navbar-toggler-icon"></span>
                </button>
            </div>
            <div class="collapse navbar-collapse order-lg-1 flex-grow-1" id="mainNav">
                <ul class="navbar-nav ms-lg-4 gap-lg-1">
                    <li class="nav-item">
                        <a class="nav-link <?php echo $activeMenu === 'dashboard' ? 'active' : ''; ?>" href="<?php echo base_url('dashboard.php'); ?>">Dashboard</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo $activeMenu === 'clients' ? 'active' : ''; ?>" href="<?php echo base_url('modules/client/index.php'); ?>">Pelanggan</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo $activeMenu === 'packages' ? 'active' : ''; ?>" href="<?php echo base_url('modules/package/index.php'); ?>">Paket</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo $activeMenu === 'payments' ? 'active' : ''; ?>" href="<?php echo base_url('modules/payment/index.php'); ?>">Pembayaran</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo $activeMenu === 'reports' ? 'active' : ''; ?>" href="<?php echo base_url('modules/report_payment/index.php'); ?>">Laporan</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link text-danger" href="<?php echo base_url('logout.php'); ?>">
                            <i class="fa-solid fa-right-from-bracket me-1"></i> Logout
                        </a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>
    <div class="topbar-meta">
        <div class="container-fluid px-0">
            <div class="d-flex flex-column flex-md-row align-items-md-center justify-content-between gap-3">
                <div>
                    <h1 class="mb-0"><?php echo htmlspecialchars($pageTitle); ?></h1>
                    <?php if (!empty($breadcrumbs)): ?>
                        <nav class="breadcrumb-nav" aria-label="Breadcrumb">
                            <ol class="breadcrumb mb-0">
                                <?php foreach ($breadcrumbs as $index => $crumb): ?>
                                    <?php $isLast = ($index === $breadcrumbLastIndex); ?>
                                    <?php if (!$isLast && !empty($crumb['url'])): ?>
                                        <li class="breadcrumb-item">
                                            <a href="<?php echo htmlspecialchars($crumb['url']); ?>"><?php echo htmlspecialchars($crumb['label']); ?></a>
                                        </li>
                                    <?php else: ?>
                                        <li class="breadcrumb-item active" aria-current="page"><?php echo htmlspecialchars($crumb['label']); ?></li>
                                    <?php endif; ?>
                                <?php endforeach; ?>
                            </ol>
                        </nav>
                    <?php endif; ?>
                </div>
                <div class="user-chip d-lg-none">
                    <i class="fa-solid fa-user-astronaut"></i>
                    <span><?php echo htmlspecialchars($user['full_name']); ?></span>
                    <span class="role-pill"><?php echo htmlspecialchars($user['role']); ?></span>
                </div>
            </div>
        </div>
    </div>
</header>
<main class="content-wrapper container-fluid">
    <?php [$flashMessage, $flashType] = get_flash_message(); ?>
    <?php if ($flashMessage): ?>
        <div class="alert alert-<?php echo htmlspecialchars($flashType); ?> alert-dismissible fade show" role="alert">
            <?php echo htmlspecialchars($flashMessage); ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>
